/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment.xml;

import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.w3c.dom.Element;
import weka.classifiers.Classifier;
import weka.core.RevisionUtils;
import weka.core.xml.XMLBasicSerialization;
import weka.core.xml.XMLDocument;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;

public class XMLExperiment
extends XMLBasicSerialization {
    public static final String NAME_CLASSFIRST = "classFirst";
    public static final String NAME_PROPERTYNODE_VALUE = "value";
    public static final String NAME_PROPERTYNODE_PARENTCLASS = "parentClass";
    public static final String NAME_PROPERTYNODE_PROPERTY = "property";

    @Override
    public void clear() throws Exception {
        super.clear();
        this.m_Properties.addIgnored("__root__.options");
        this.m_Properties.addIgnored(Experiment.class, "options");
        this.m_Properties.addAllowed(Classifier.class, "debug");
        this.m_Properties.addAllowed(Classifier.class, "options");
        this.m_Properties.addAllowed(SplitEvaluator.class, "options");
        this.m_Properties.addAllowed(ResultProducer.class, "options");
        this.m_CustomMethods.register(this, PropertyNode.class, "PropertyNode");
    }

    @Override
    protected void writePostProcess(Object o) throws Exception {
        Experiment exp = (Experiment)o;
        Element node = this.addElement(this.m_Document.getDocument().getDocumentElement(), NAME_CLASSFIRST, Boolean.class.getName(), false);
        node.appendChild(node.getOwnerDocument().createTextNode(new Boolean(false).toString()));
    }

    @Override
    protected Object readPostProcess(Object o) throws Exception {
        Experiment exp = (Experiment)o;
        Vector<Element> children = XMLDocument.getChildTags(this.m_Document.getDocument().getDocumentElement());
        int i = 0;
        while (i < children.size()) {
            Element node = children.get(i);
            if (node.getAttribute("name").equals(NAME_CLASSFIRST)) {
                exp.classFirst(new Boolean(XMLDocument.getContent(node)));
                break;
            }
            ++i;
        }
        return o;
    }

    public Element writePropertyNode(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        PropertyNode pnode = (PropertyNode)o;
        Element node = (Element)parent.appendChild(this.m_Document.getDocument().createElement("object"));
        node.setAttribute("name", name);
        node.setAttribute("class", pnode.getClass().getName());
        node.setAttribute("primitive", "no");
        node.setAttribute("array", "no");
        if (pnode.value != null) {
            this.invokeWriteToXML(node, pnode.value, NAME_PROPERTYNODE_VALUE);
        }
        if (pnode.parentClass != null) {
            this.invokeWriteToXML(node, pnode.parentClass.getName(), NAME_PROPERTYNODE_PARENTCLASS);
        }
        if (pnode.property != null) {
            this.invokeWriteToXML(node, pnode.property.getDisplayName(), NAME_PROPERTYNODE_PROPERTY);
        }
        if (pnode.value != null && pnode.property != null && pnode.property.getPropertyType().isPrimitive()) {
            Vector<Element> children = XMLDocument.getChildTags(node);
            int i = 0;
            while (i < children.size()) {
                Element child = children.get(i);
                if (child.getAttribute("name").equals(NAME_PROPERTYNODE_VALUE)) {
                    child.setAttribute("class", pnode.property.getPropertyType().getName());
                    child.setAttribute("primitive", "yes");
                }
                ++i;
            }
        }
        return node;
    }

    public Object readPropertyNode(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute("name"));
        }
        this.m_CurrentNode = node;
        PropertyNode result = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        Object value = null;
        String parentClass = null;
        String property = null;
        int i = 0;
        while (i < children.size()) {
            Element child = children.get(i);
            if (child.getAttribute("name").equals(NAME_PROPERTYNODE_VALUE)) {
                value = this.stringToBoolean(child.getAttribute("primitive")) ? this.getPrimitive(child) : this.invokeReadFromXML(child);
            }
            if (child.getAttribute("name").equals(NAME_PROPERTYNODE_PARENTCLASS)) {
                parentClass = XMLDocument.getContent(child);
            }
            if (child.getAttribute("name").equals(NAME_PROPERTYNODE_PROPERTY)) {
                property = XMLDocument.getContent(child);
            }
            ++i;
        }
        Class<?> cls = parentClass != null ? Class.forName(parentClass) : null;
        result = cls != null ? new PropertyNode(value, new PropertyDescriptor(property, cls), cls) : new PropertyNode(value);
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            if (args[0].toLowerCase().endsWith(".xml")) {
                System.out.println(new XMLExperiment().read(args[0]).toString());
            } else {
                FileInputStream fi = new FileInputStream(args[0]);
                ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(fi));
                Object o = oi.readObject();
                oi.close();
                new XMLExperiment().write(new BufferedOutputStream(new FileOutputStream(String.valueOf(args[0]) + ".xml")), o);
                FileOutputStream fo = new FileOutputStream(String.valueOf(args[0]) + ".exp");
                ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(fo));
                oo.writeObject(o);
                oo.close();
            }
        }
    }
}

